/*
	File: CEG_controls.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to load functions into memory if the CEG System Dialog is created to update controls and perform other dialog functions.

	Parameters:
	None.
	
	Execution:
	Executed by CEG_system.sqf (and only once per mission per client as detemined by the GV CEG_controls).
*/

_nul = [] execVM "CEG\Functions\CEG_fnc_user.sqf";
_nul = [] execVM "CEG\Functions\CEG_fnc_overview.sqf";
_nul = [] execVM "CEG\Functions\CEG_fnc_status.sqf";
_nul = [] execVM "CEG\Functions\CEG_fnc_commands.sqf";
_nul = [] execVM "CEG\Functions\CEG_fnc_node.sqf";
_nul = [] execVM "CEG\Functions\CEG_fnc_video.sqf";

// If the mission maker has not enabled the CCTV night vision option (by declaring CEG_NVG = true in the init.sqf), then ensure it is disabled.  Also ensure CEG_light and CEG_dark have default values assigned.
if (isNil "CEG_NVG") then {CEG_NVG = false};
if (isNil "CEG_dark") then {CEG_dark = 19};
if (isNil "CEG_light") then {CEG_light = 6};

// Assign the value to true once this script is run once so that it is not loaded every time CEG_system.sqf is executed.
CEG_controls = true;